/* <nagx04.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library x04 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2169 (Feb 1998).
 * Mark 6 revised. IER-3059 (July 2000).
 * Mark 6 revised. IER-3120 (September 2000).
 * Mark 7 revised. (August 2001).
 */
#ifndef NAGX04
#define NAGX04

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
//#include <nag_stddef.h>   //Cheney 2006-6-5
#include "nag_stddef.h"
#include <stdio.h>

  /* Definitions */
#define MAX_FORMAT 81
#define X04_MAX_LINE 132
#define STD_LINE 80
#define OUTPUT_BUF_LEN (2*X04_MAX_LINE)
#define INTNL_FMT_LEN 15
  /* Length allowed for internally generated
   * format strings 
   */

  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL x04aaf_f(Integer i, Integer *nerr);
  extern void x04aaz(const char *str);
  extern void x04abf_f(Integer i, Integer *nadv);
  extern void x04acy(const char *outfile, Integer mode, Integer *nadv,
                     NagError *fail);
  extern void x04baf_f(Integer nout, const char *rec, Integer rec_len);
  extern void x04bat(void);
  extern int x04bau(FILE *fp_in);
  //Cheney 2006-6-5 change *string to *str
  /*extern void x04bav(Nag_FileSt *stream, const char *string);*/
  extern void x04bav(Nag_FileSt *stream, const char *str);
  //Cheney 2006-6-5 change *string to *str
  /*extern void x04baw(Nag_FileSt *stream, const char *string);*/
  extern void x04baw(Nag_FileSt *stream, const char *str);
  extern FILE *x04bax(const char *input_file_name);
  extern void x04bay_f(Integer nout, Integer nrec, char *rec, Integer rec_len);
  //Cheney 2006-6-5 change *string to *str
  /*extern NAG_DLL_EXPIMP void NAG_CALL x04bay(const char *output_file_name, const char *string);*/
  extern NAG_DLL_EXPIMP void NAG_CALL x04bay(const char *output_file_name, const char *str);
  extern void x04baz(Nag_FileSt *stream, const char *str, int code, Nag_Mesg *mesg);
  extern NAG_DLL_EXPIMP Pointer NAG_CALL x04bbc(size_t size);
  extern void x04bbz(char str[]);
  extern NAG_DLL_EXPIMP Pointer NAG_CALL x04bcc(Pointer ptr, size_t newsize);
  extern NAG_DLL_EXPIMP void NAG_CALL x04bcz(char str[]);
  extern NAG_DLL_EXPIMP void NAG_CALL x04bdc(Pointer *ptr);
  extern void x04caf_f(char *mat, char *diag, Integer m, Integer n,
                       const double a[], Integer lda, char *title, Integer *ifail);
  extern char *x04caz(char *s1, char *s2, int n);
  extern void x04cbf_f(char *mat, char *diag, Integer m, Integer n,
                       const double a[], Integer lda, char *format, char *title,
                       char *labrow, char **rlabs, char *labcol, char **clabs,
                       Integer ncols, Integer indent, Integer *ifail);
  //Cheney 2006-6-5 change *string to *str
  /*extern void x04cbz_f(char *string, Integer *start, Integer *finish, Integer string_len);*/
  extern void x04cbz_f(char *str, Integer *start, Integer *finish, Integer string_len);
  extern void x04eaf_f(char *mat, char *diag, Integer m, Integer n,
                       const Integer a[], Integer lda, char *title, Integer *ifail,
                       Integer matrix_len, Integer diag_len, Integer title_len);
  extern void x04ebf_f(char *mat, char *diag, Integer m, Integer n,
                       const Integer a[], Integer lda, char *format, char *title,
                       char *labrow, char *rlabs, char *labcol, char *clabs,
                       Integer ncols, Integer indent, Integer *ifail, Integer matrix_len,
                       Integer diag_len, Integer format_len, Integer title_len, Integer labrow_len,
                       Integer rlabs_len, Integer labcol_len, Integer clabs_len);
  extern Nag_HashError x04fag(Nag_HashTable *htable, unsigned long approx_size);
  extern void x04fah(Nag_HashTable *htable);
  extern Pointer x04faj(Nag_HashTable *htable, const char *name);
  extern void x04fak(Nag_HashTable *htable, Pointer data, const char *name, 
                     Nag_HashError *error);
  extern Pointer x04fal(Nag_HashTable *htable, Pointer data, const char *name, 
                        Nag_HashError *error);
  extern void x04fam(Nag_HashTable *htable, Pointer old_base, Pointer new_base,
                     size_t offset);
  extern NAG_DLL_EXPIMP int NAG_CALL x04mac(const char *enum_string);
  extern NAG_DLL_EXPIMP int NAG_CALL x04mbc(const char *error_name_string);
  extern NAG_DLL_EXPIMP char * NAG_CALL x04mcc(int enum_value, char *enum_string);

  extern NAG_DLL_EXPIMP void NAG_CALL x04bah(
	      FILE *f_out, const char *rec, Integer rec_len, Integer *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04cac(
	      Nag_OrderType order, Nag_MatrixType mat, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const double a[], Integer pda, const char *title,
	      const char *outfile, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04cbc(
	      Nag_OrderType order, Nag_MatrixType mat, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const double a[], Integer pda, const char *format, 
	      const char *title, Nag_LabelType labrow, char **rlabs, 
	      Nag_LabelType labcol, char **clabs,
	      Integer ncols, Integer indent, const char *outfile, 
	      NagError *fail);

  extern void x04cby(Nag_OrderType order, 
	       Nag_MatrixType mat, Nag_DiagType diag, 
	       Integer m, Integer n, const double a[], Integer lda, 
	       const char *format, char *title,
	       Nag_LabelType labrow, char **rlabs, Nag_LabelType labcol,
	       char **clabs, Integer ncols, Integer indent, 
	       const char *outfile, Integer *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04ccc(
              Nag_OrderType order, Nag_UploType uplo, 
	      Nag_DiagType diag, Integer n, const double a[], 
              const char *title, const char *outfile, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04cdc(
              Nag_OrderType order, Nag_UploType uplo, 
              Nag_DiagType diag, Integer n, const double a[], const char *format, 
	      const char *title, Nag_LabelType labrow, char **rlabs, 
	      Nag_LabelType labcol, char **clabs, Integer ncols, 
	      Integer indent, const char *outfile,  NagError *fail);

  extern void x04ccz(char *format, Integer *error);
  extern void x04cdz(char *format, Integer *error);

  extern void x04cdy(Nag_OrderType order, Nag_UploType uplo, 
              Nag_DiagType diag, Integer n, const double a[], const char *format, 
              char *title, Nag_LabelType labrow, char **rlabs, Nag_LabelType labcol,
	      char **clabs, Integer ncols, Integer indent, 
              const char *outfile, Integer *fail);
  
  extern NAG_DLL_EXPIMP void NAG_CALL x04cec(
              Nag_OrderType order, Integer m, Integer n, 
	      Integer kl, Integer ku, const double ab[], 
	      Integer pda, const char *title, const char *outfile, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04cfc(
                     Nag_OrderType order, Integer m, Integer n, Integer kl, 
		     Integer ku, const double ab[], Integer pda, 
		     const char *format, const char *title, Nag_LabelType labrow, 
		     char **rlabs, Nag_LabelType labcol, char **clabs, 
		     Integer ncols, Integer indent, const char *outfile, 
                     NagError *fail); 

  extern void x04cfy(Nag_OrderType order, Integer m, Integer n, Integer kl, 
		     Integer ku, const double a[], Integer lda, 
		     const char *format, char *title, Nag_LabelType labrow,
		     char **rlabs, Nag_LabelType labcol, char **clabs, 
		     Integer ncols, Integer indent, const char *outfile, 
                     Integer *ifail); 
  //Cheney change Complex to complex 
  extern NAG_DLL_EXPIMP void NAG_CALL x04dac(
              Nag_OrderType order, Nag_MatrixType mat, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const complex a[], Integer pda, const char *title,
	      const char *outfile, NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04dbc(
              Nag_OrderType order, Nag_MatrixType mat, 
	      Nag_DiagType diag, Integer m,
	      Integer n, const complex a[], Integer pda, 
	      Nag_ComplexFormType cmplxform,
	      const char *format, const char *title, Nag_LabelType labrow, 
	      char **rlabs, Nag_LabelType labcol, char **clabs,
	      Integer ncols, Integer indent, const char *outfile, NagError *fail);

  extern void x04dby(Nag_OrderType order, Nag_MatrixType mat, 
	      Nag_DiagType diag, Integer m, Integer n,
	      const complex a[], Integer lda, Nag_ComplexFormType cmplxform, 
	      const char *format, char *title, Nag_LabelType labrow, 
	      char **rlabs, Nag_LabelType labcol, char **clabs,
	      Integer ncols, Integer indent, const char *outfile, Integer *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04dcc(
            Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
	    Integer n, const Complex a[], const char *title, 
            const char *outfile,  NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04ddc(
            Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
	    Integer n, const complex a[], Nag_ComplexFormType cmplxform,
	    const char *format, const char *title, Nag_LabelType labrow, 
	    char **rlabs, Nag_LabelType labcol, char **clabs, Integer ncols, 
	    Integer indent, const char *outfile, NagError *fail);

  extern void  x04ddy(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
		      Integer n, const complex a[], Nag_ComplexFormType cmplxform,
		      const char *format, char *title, Nag_LabelType labrow, 
		      char **rlabs, Nag_LabelType labcol, char **clabs, Integer ncols, 
		      Integer indent, const char *outfile, Integer *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04dec(
                     Nag_OrderType order, Integer m, Integer n, 
		     Integer kl, Integer ku, const complex ab[], 
		     Integer pda, const char *title, const char *outfile, 
                     NagError *fail);

  extern NAG_DLL_EXPIMP void NAG_CALL x04dfc(
                     Nag_OrderType order, Integer m, Integer n, Integer kl, 
		     Integer ku, const complex ab[], Integer pda, 
		     Nag_ComplexFormType cmplxform, const char *format, 
		     const char *title, Nag_LabelType labrow, char **rlabs, 
		     Nag_LabelType labcol, char **clabs, 
		     Integer ncols, Integer indent, const char *outfile, 
                     NagError *fail);

  extern void x04dfy(Nag_OrderType order, Integer m, Integer n, Integer kl, 
		     Integer ku, const complex a[], Integer lda, 
		     Nag_ComplexFormType cmplxform, const char *format, 
		     char *title, Nag_LabelType labrow, char **rlabs, 
		     Nag_LabelType labcol, char **clabs, 
		     Integer ncols, Integer indent, const char *outfile, 
                     Integer *ifail);

  /* Used by some C wrappers */
  extern void f90_io_init(void);

  /* end proto */
#ifdef __cplusplus
}
#endif

#ifndef NAG_FREE // Jack 6/30/2008 add this marco here because cannot compile  NAG_FREE(x) in fitting function
#ifndef _MSC_VER
#define NAG_FREE(x) x04bdc((Pointer *)&(x))
#endif // !_MSC_VER
#endif // !NAG_FREE

#endif /* not NAGX04 */
